/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.debugger;

import com.aptana.php.debug.core.launch.remote.RemoteDebugRedirector;
import com.aptana.php.debug.core.util.NameValuePair;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org2.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org2.eclipse.php.debug.core.debugger.parameters.IWebDebugParametersInitializer;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org2.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org2.eclipse.php.internal.debug.core.zend.debugger.IDebuggerInitializer;

public class PHPWebServerDebuggerInitializer
implements IDebuggerInitializer {
    @Override
    public void debug(ILaunch launch) throws DebugException {
        IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(launch);
        boolean openInBrowser = false;
        boolean useInternalBrowser = false;
        try {
            openInBrowser = launch.getLaunchConfiguration().getAttribute("org2.eclipse.php.debug.core.OpenInBrowser", false);
            useInternalBrowser = launch.getLaunchConfiguration().getAttribute("org2.eclipse.php.debug.core.UseExternalBrowser", false);
        }
        catch (CoreException coreException) {}
        if (openInBrowser) {
            this.openBrowser(launch, parametersInitializer, useInternalBrowser);
        } else {
            this.openUrlConnection(launch, parametersInitializer);
        }
    }

    protected void openBrowser(final ILaunch launch, IDebugParametersInitializer parametersInitializer, final boolean useInternalBrowser) throws DebugException {
        boolean runWithDebug = true;
        try {
            runWithDebug = launch.getLaunchConfiguration().getAttribute("org2.eclipse.php.debug.core.RunWithDebugInfo", true);
        }
        catch (CoreException coreException) {}
        URL requestURL = parametersInitializer.getRequestURL(launch);
        List getData = Collections.EMPTY_LIST;
        try {
            getData = launch.getLaunchConfiguration().getAttribute("ATTR_HTTP_GET", Collections.EMPTY_LIST);
        }
        catch (CoreException e1) {
            Logger.logException(e1);
        }
        StringBuilder urlQuery = new StringBuilder();
        if (requestURL.getQuery() != null) {
            urlQuery.append('?');
            urlQuery.append(requestURL.getQuery());
        }
        if (!getData.isEmpty()) {
            if (urlQuery.length() > 0) {
                urlQuery.append('&');
            } else {
                urlQuery.append('?');
            }
            try {
                this.fillParams(getData, urlQuery);
            }
            catch (UnsupportedEncodingException e) {
                Logger.logException(e);
                String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                throw new DebugException((IStatus)new Status(4, "com.aptana.php.debug.epl", 150, errorMessage, (Throwable)e));
            }
        }
        try {
            String query;
            if (runWithDebug && !"run".equals(launch.getLaunchMode()) && (query = PHPLaunchUtilities.generateQuery(launch, parametersInitializer)) != null && query.length() > 0) {
                if (urlQuery.length() > 0) {
                    urlQuery.append('&');
                    urlQuery.append(query);
                } else {
                    urlQuery.append('?');
                    urlQuery.append(query);
                }
            }
            requestURL = new URL(requestURL.getProtocol(), requestURL.getHost(), requestURL.getPort(), String.valueOf(requestURL.getPath()) + urlQuery.toString());
        }
        catch (MalformedURLException e) {
            Logger.logException(e);
            String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
            throw new DebugException((IStatus)new Status(4, "com.aptana.php.debug.epl", 150, errorMessage, (Throwable)e));
        }
        final DebugException[] exception = new DebugException[1];
        final URL debugURL = requestURL;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    List postData = launch.getLaunchConfiguration().getAttribute("ATTR_HTTP_POST", Collections.EMPTY_LIST);
                    boolean hasPostData = postData != null && !postData.isEmpty();
                    IWebBrowser browser = null;
                    if (useInternalBrowser) {
                        StringBuilder browserTitle = new StringBuilder(debugURL.getProtocol()).append("://").append(debugURL.getHost());
                        if (debugURL.getPort() != -1) {
                            browserTitle.append(':').append(debugURL.getPort());
                        }
                        browserTitle.append(debugURL.getPath());
                        browser = PHPLaunchUtilities.openInternalBrowser(browserTitle.toString());
                        Browser.clearSessions();
                    } else {
                        browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    }
                    if (hasPostData) {
                        new RemoteDebugRedirector().redirect(browser, debugURL, postData);
                    } else {
                        browser.openURL(debugURL);
                    }
                    if (PHPDebugEPLPlugin.DEBUG) {
                        System.out.println("Opening URL in a browser: " + debugURL.toString());
                    }
                }
                catch (Throwable t) {
                    Logger.logException("Error initializing the web browser.", t);
                    String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                    exception[0] = new DebugException((IStatus)new Status(4, "com.aptana.php.debug.epl", 150, errorMessage, t));
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    protected void openUrlConnection(ILaunch launch, IDebugParametersInitializer parametersInitializer) throws DebugException {
        block26: {
            URL requestURL = parametersInitializer.getRequestURL(launch);
            try {
                Hashtable<String, String> cookies;
                String paramsString;
                if (!(parametersInitializer instanceof IWebDebugParametersInitializer)) break block26;
                IWebDebugParametersInitializer webParametersInitializer = (IWebDebugParametersInitializer)parametersInitializer;
                StringBuilder getParams = new StringBuilder();
                List getRequestParameters = launch.getLaunchConfiguration().getAttribute("ATTR_HTTP_GET", Collections.EMPTY_LIST);
                String queryInURL = requestURL.getQuery();
                if (queryInURL != null) {
                    getParams.append(queryInURL);
                    getParams.append('&');
                }
                this.fillParams(getRequestParameters, getParams);
                getParams.append('&');
                Hashtable<String, String> debugParameters = parametersInitializer.getDebugParameters(launch);
                if (debugParameters != null && !debugParameters.isEmpty()) {
                    Enumeration<String> k = debugParameters.keys();
                    while (k.hasMoreElements()) {
                        String key = k.nextElement();
                        String value = debugParameters.get(key);
                        getParams.append(URLEncoder.encode(key, "UTF-8")).append('=').append(URLEncoder.encode(value, "UTF-8"));
                        if (!k.hasMoreElements()) continue;
                        getParams.append('&');
                    }
                }
                if ((paramsString = getParams.toString()).length() != 0) {
                    paramsString = String.valueOf('?') + paramsString;
                }
                if (paramsString.endsWith("&")) {
                    paramsString = paramsString.substring(0, paramsString.length() - 1);
                }
                requestURL = new URL(requestURL.getProtocol(), requestURL.getHost(), requestURL.getPort(), String.valueOf(requestURL.getPath()) + paramsString);
                if (PHPDebugEPLPlugin.DEBUG) {
                    System.out.println("Opening URL connection: " + requestURL.toString());
                }
                HttpURLConnection urlConection = (HttpURLConnection)requestURL.openConnection();
                urlConection.setDoInput(true);
                urlConection.setDoOutput(true);
                Hashtable<String, String> headers = webParametersInitializer.getRequestHeaders(launch);
                if (headers != null) {
                    Enumeration<String> k = headers.keys();
                    while (k.hasMoreElements()) {
                        String key = k.nextElement();
                        String value = URLEncoder.encode(headers.get(key), "UTF-8");
                        if (PHPDebugEPLPlugin.DEBUG) {
                            System.out.println("Adding HTTP header: " + key + "=" + value);
                        }
                        urlConection.addRequestProperty(key, value);
                    }
                }
                if ((cookies = webParametersInitializer.getRequestCookies(launch)) != null) {
                    StringBuilder cookieBuf = new StringBuilder();
                    Enumeration<String> k = cookies.keys();
                    while (k.hasMoreElements()) {
                        String key = k.nextElement();
                        String value = cookies.get(key);
                        cookieBuf.append(URLEncoder.encode(key, "UTF-8")).append('=').append(URLEncoder.encode(value, "UTF-8"));
                        if (!k.hasMoreElements()) continue;
                        cookieBuf.append("; ");
                    }
                    if (PHPDebugEPLPlugin.DEBUG) {
                        System.out.println("Setting cookies: " + cookieBuf.toString());
                    }
                    urlConection.addRequestProperty("Cookie", cookieBuf.toString());
                }
                DataOutputStream outputStream = new DataOutputStream(urlConection.getOutputStream());
                try {
                    String rawData;
                    List postRequestParameters = launch.getLaunchConfiguration().getAttribute("ATTR_HTTP_POST", Collections.EMPTY_LIST);
                    StringBuilder postParams = new StringBuilder();
                    this.fillParams(postRequestParameters, postParams);
                    if (postParams.length() > 0) {
                        outputStream.writeBytes(postParams.toString());
                    }
                    if ((rawData = webParametersInitializer.getRequestRawData(launch)) != null) {
                        outputStream.writeBytes(rawData);
                    }
                }
                finally {
                    outputStream.flush();
                    outputStream.close();
                }
                String headerKey = urlConection.getHeaderFieldKey(1);
                if (headerKey == null) {
                    Logger.log(2, "No HeaderKey returned by server. Most likely not started");
                    String errorMessage = PHPDebugCoreMessages.DebuggerConnection_Problem_1;
                    throw new DebugException((IStatus)new Status(4, "com.aptana.php.debug.epl", 150, errorMessage, null));
                }
                int i = 1;
                while ((headerKey = urlConection.getHeaderFieldKey(i)) != null) {
                    if (headerKey.equals("X-Zend-Debug-Server")) {
                        String headerValue = urlConection.getHeaderField(headerKey);
                        if (headerValue.equals("OK")) break;
                        Logger.log(2, "Unexpected Header Value returned by Server. " + headerValue);
                        String errorMessage = String.valueOf(PHPDebugCoreMessages.DebuggerConnection_Problem_2) + " - " + headerValue;
                        throw new DebugException((IStatus)new Status(4, "com.aptana.php.debug.epl", 150, errorMessage, null));
                    }
                    ++i;
                }
                InputStream inputStream = urlConection.getInputStream();
                while (inputStream.read() != -1) {
                }
                inputStream.close();
            }
            catch (UnknownHostException e) {
                Logger.logException("Unknown host: " + requestURL.getHost(), e);
            }
            catch (ConnectException e) {
                Logger.logException("Unable to connect to URL " + requestURL, e);
            }
            catch (IOException e) {
                Logger.logException("Unable to connect to URL " + requestURL, e);
            }
            catch (Exception e) {
                Logger.logException("Unexpected exception communicating with Web server", e);
                String errorMessage = e.getMessage();
                throw new DebugException((IStatus)new Status(4, "com.aptana.php.debug.epl", 150, errorMessage, (Throwable)e));
            }
        }
    }

    private void fillParams(List requestParams, StringBuilder paramsBuilder) throws UnsupportedEncodingException {
        int size = requestParams.size();
        int i = 0;
        while (i < size) {
            NameValuePair nameValuePair = NameValuePair.fromPairString((String)requestParams.get(i).toString());
            if (nameValuePair != null) {
                paramsBuilder.append(URLEncoder.encode(nameValuePair.name, "UTF-8")).append('=').append(URLEncoder.encode(nameValuePair.value, "UTF-8"));
                if (i + 1 < size) {
                    paramsBuilder.append('&');
                }
            }
            ++i;
        }
    }
}

